package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorVerifyJsonWebTokenForDcpArgs private(
  authorizations: Output[Option[String]],
  clientId: Output[Option[String]],
  customHeader: Output[Option[Boolean]],
  enableEs256: Output[Option[Boolean]],
  enableRs256: Output[Option[Boolean]],
  extractAuthorizations: Output[Option[Boolean]],
  extractClientId: Output[Option[Boolean]],
  extractLocation: Output[Option[String]],
  extractUserName: Output[Option[Boolean]],
  headerName: Output[Option[String]],
  jwt: Output[Option[String]],
  locked: Output[Option[Boolean]],
  primaryLocation: Output[Option[String]],
  queryParameterName: Output[Option[String]],
  templateUuid: Output[Option[String]],
  userName: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorVerifyJsonWebTokenForDcpArgs:
  def apply(
    authorizations: Input.Optional[String] = None,
    clientId: Input.Optional[String] = None,
    customHeader: Input.Optional[Boolean] = None,
    enableEs256: Input.Optional[Boolean] = None,
    enableRs256: Input.Optional[Boolean] = None,
    extractAuthorizations: Input.Optional[Boolean] = None,
    extractClientId: Input.Optional[Boolean] = None,
    extractLocation: Input.Optional[String] = None,
    extractUserName: Input.Optional[Boolean] = None,
    headerName: Input.Optional[String] = None,
    jwt: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    primaryLocation: Input.Optional[String] = None,
    queryParameterName: Input.Optional[String] = None,
    templateUuid: Input.Optional[String] = None,
    userName: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorVerifyJsonWebTokenForDcpArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorVerifyJsonWebTokenForDcpArgs(
      authorizations = authorizations.asOptionOutput(isSecret = false),
      clientId = clientId.asOptionOutput(isSecret = false),
      customHeader = customHeader.asOptionOutput(isSecret = false),
      enableEs256 = enableEs256.asOptionOutput(isSecret = false),
      enableRs256 = enableRs256.asOptionOutput(isSecret = false),
      extractAuthorizations = extractAuthorizations.asOptionOutput(isSecret = false),
      extractClientId = extractClientId.asOptionOutput(isSecret = false),
      extractLocation = extractLocation.asOptionOutput(isSecret = false),
      extractUserName = extractUserName.asOptionOutput(isSecret = false),
      headerName = headerName.asOptionOutput(isSecret = false),
      jwt = jwt.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      primaryLocation = primaryLocation.asOptionOutput(isSecret = false),
      queryParameterName = queryParameterName.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      userName = userName.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
