package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530BehaviorVirtualWaitingRoomArgs private(
  accessTitle: Output[Option[String]],
  cloudletSharedPolicy: Output[Option[Int]],
  customCookieDomain: Output[Option[String]],
  domainConfig: Output[Option[String]],
  locked: Output[Option[Boolean]],
  sessionAutoProlong: Output[Option[Boolean]],
  sessionDuration: Output[Option[Int]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]],
  waitingRoomAssetsPaths: Output[Option[scala.collection.immutable.List[String]]],
  waitingRoomPath: Output[Option[String]],
  waitingRoomTitle: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530BehaviorVirtualWaitingRoomArgs:
  def apply(
    accessTitle: Input.Optional[String] = None,
    cloudletSharedPolicy: Input.Optional[Int] = None,
    customCookieDomain: Input.Optional[String] = None,
    domainConfig: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    sessionAutoProlong: Input.Optional[Boolean] = None,
    sessionDuration: Input.Optional[Int] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None,
    waitingRoomAssetsPaths: Input.Optional[List[Input[String]]] = None,
    waitingRoomPath: Input.Optional[String] = None,
    waitingRoomTitle: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530BehaviorVirtualWaitingRoomArgs =
    new GetPropertyRulesBuilderRulesV20230530BehaviorVirtualWaitingRoomArgs(
      accessTitle = accessTitle.asOptionOutput(isSecret = false),
      cloudletSharedPolicy = cloudletSharedPolicy.asOptionOutput(isSecret = false),
      customCookieDomain = customCookieDomain.asOptionOutput(isSecret = false),
      domainConfig = domainConfig.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      sessionAutoProlong = sessionAutoProlong.asOptionOutput(isSecret = false),
      sessionDuration = sessionDuration.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false),
      waitingRoomAssetsPaths = waitingRoomAssetsPaths.asOptionOutput(isSecret = false),
      waitingRoomPath = waitingRoomPath.asOptionOutput(isSecret = false),
      waitingRoomTitle = waitingRoomTitle.asOptionOutput(isSecret = false)
    )
