package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530CriterionBucketArgs private(
  locked: Output[Option[Boolean]],
  percentage: Output[Option[Int]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530CriterionBucketArgs:
  def apply(
    locked: Input.Optional[Boolean] = None,
    percentage: Input.Optional[Int] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530CriterionBucketArgs =
    new GetPropertyRulesBuilderRulesV20230530CriterionBucketArgs(
      locked = locked.asOptionOutput(isSecret = false),
      percentage = percentage.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
