package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530CriterionClientCertificateArgs private(
  isCertificatePresent: Output[Option[Boolean]],
  isCertificateValid: Output[Option[String]],
  locked: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530CriterionClientCertificateArgs:
  def apply(
    isCertificatePresent: Input.Optional[Boolean] = None,
    isCertificateValid: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530CriterionClientCertificateArgs =
    new GetPropertyRulesBuilderRulesV20230530CriterionClientCertificateArgs(
      isCertificatePresent = isCertificatePresent.asOptionOutput(isSecret = false),
      isCertificateValid = isCertificateValid.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
