package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530CriterionDeviceCharacteristicArgs private(
  booleanValue: Output[Option[Boolean]],
  characteristic: Output[Option[String]],
  locked: Output[Option[Boolean]],
  matchCaseSensitive: Output[Option[Boolean]],
  matchWildcard: Output[Option[Boolean]],
  numericMatchOperator: Output[Option[String]],
  numericValue: Output[Option[Int]],
  stringMatchOperator: Output[Option[String]],
  stringValues: Output[Option[scala.collection.immutable.List[String]]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]],
  versionMatchOperator: Output[Option[String]],
  versionValue: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530CriterionDeviceCharacteristicArgs:
  def apply(
    booleanValue: Input.Optional[Boolean] = None,
    characteristic: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    matchCaseSensitive: Input.Optional[Boolean] = None,
    matchWildcard: Input.Optional[Boolean] = None,
    numericMatchOperator: Input.Optional[String] = None,
    numericValue: Input.Optional[Int] = None,
    stringMatchOperator: Input.Optional[String] = None,
    stringValues: Input.Optional[List[Input[String]]] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None,
    versionMatchOperator: Input.Optional[String] = None,
    versionValue: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530CriterionDeviceCharacteristicArgs =
    new GetPropertyRulesBuilderRulesV20230530CriterionDeviceCharacteristicArgs(
      booleanValue = booleanValue.asOptionOutput(isSecret = false),
      characteristic = characteristic.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      matchCaseSensitive = matchCaseSensitive.asOptionOutput(isSecret = false),
      matchWildcard = matchWildcard.asOptionOutput(isSecret = false),
      numericMatchOperator = numericMatchOperator.asOptionOutput(isSecret = false),
      numericValue = numericValue.asOptionOutput(isSecret = false),
      stringMatchOperator = stringMatchOperator.asOptionOutput(isSecret = false),
      stringValues = stringValues.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false),
      versionMatchOperator = versionMatchOperator.asOptionOutput(isSecret = false),
      versionValue = versionValue.asOptionOutput(isSecret = false)
    )
