package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530CriterionRequestHeaderArgs private(
  headerName: Output[Option[String]],
  locked: Output[Option[Boolean]],
  matchCaseSensitiveValue: Output[Option[Boolean]],
  matchOperator: Output[Option[String]],
  matchWildcardName: Output[Option[Boolean]],
  matchWildcardValue: Output[Option[Boolean]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]],
  values: Output[Option[scala.collection.immutable.List[String]]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530CriterionRequestHeaderArgs:
  def apply(
    headerName: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    matchCaseSensitiveValue: Input.Optional[Boolean] = None,
    matchOperator: Input.Optional[String] = None,
    matchWildcardName: Input.Optional[Boolean] = None,
    matchWildcardValue: Input.Optional[Boolean] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None,
    values: Input.Optional[List[Input[String]]] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530CriterionRequestHeaderArgs =
    new GetPropertyRulesBuilderRulesV20230530CriterionRequestHeaderArgs(
      headerName = headerName.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      matchCaseSensitiveValue = matchCaseSensitiveValue.asOptionOutput(isSecret = false),
      matchOperator = matchOperator.asOptionOutput(isSecret = false),
      matchWildcardName = matchWildcardName.asOptionOutput(isSecret = false),
      matchWildcardValue = matchWildcardValue.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false),
      values = values.asOptionOutput(isSecret = false)
    )
