package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530CriterionServerLocationArgs private(
  continents: Output[Option[scala.collection.immutable.List[String]]],
  countries: Output[Option[scala.collection.immutable.List[String]]],
  locationType: Output[Option[String]],
  locked: Output[Option[Boolean]],
  matchOperator: Output[Option[String]],
  regions: Output[Option[scala.collection.immutable.List[String]]],
  templateUuid: Output[Option[String]],
  uuid: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530CriterionServerLocationArgs:
  def apply(
    continents: Input.Optional[List[Input[String]]] = None,
    countries: Input.Optional[List[Input[String]]] = None,
    locationType: Input.Optional[String] = None,
    locked: Input.Optional[Boolean] = None,
    matchOperator: Input.Optional[String] = None,
    regions: Input.Optional[List[Input[String]]] = None,
    templateUuid: Input.Optional[String] = None,
    uuid: Input.Optional[String] = None
  )(using Context): GetPropertyRulesBuilderRulesV20230530CriterionServerLocationArgs =
    new GetPropertyRulesBuilderRulesV20230530CriterionServerLocationArgs(
      continents = continents.asOptionOutput(isSecret = false),
      countries = countries.asOptionOutput(isSecret = false),
      locationType = locationType.asOptionOutput(isSecret = false),
      locked = locked.asOptionOutput(isSecret = false),
      matchOperator = matchOperator.asOptionOutput(isSecret = false),
      regions = regions.asOptionOutput(isSecret = false),
      templateUuid = templateUuid.asOptionOutput(isSecret = false),
      uuid = uuid.asOptionOutput(isSecret = false)
    )
