package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesBuilderRulesV20230530VariableArgs private(
  description: Output[String],
  hidden: Output[Boolean],
  name: Output[String],
  sensitive: Output[Boolean],
  value: Output[String]
) derives Encoder, ArgsEncoder

object GetPropertyRulesBuilderRulesV20230530VariableArgs:
  def apply(
    description: Input[String],
    hidden: Input[Boolean],
    name: Input[String],
    sensitive: Input[Boolean],
    value: Input[String]
  )(using Context): GetPropertyRulesBuilderRulesV20230530VariableArgs =
    new GetPropertyRulesBuilderRulesV20230530VariableArgs(
      description = description.asOutput(isSecret = false),
      hidden = hidden.asOutput(isSecret = false),
      name = name.asOutput(isSecret = false),
      sensitive = sensitive.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
