package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesTemplateTemplateArgs private(
  templateData: Output[String],
  templateDir: Output[String]
) derives Encoder, ArgsEncoder

object GetPropertyRulesTemplateTemplateArgs:
  def apply(
    templateData: Input[String],
    templateDir: Input[String]
  )(using Context): GetPropertyRulesTemplateTemplateArgs =
    new GetPropertyRulesTemplateTemplateArgs(
      templateData = templateData.asOutput(isSecret = false),
      templateDir = templateDir.asOutput(isSecret = false)
    )
