package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPropertyRulesTemplateVariableArgs private(
  name: Output[String],
  `type`: Output[Option[String]],
  value: Output[String]
) derives Encoder, ArgsEncoder

object GetPropertyRulesTemplateVariableArgs:
  def apply(
    name: Input[String],
    `type`: Input.Optional[String] = None,
    value: Input[String]
  )(using Context): GetPropertyRulesTemplateVariableArgs =
    new GetPropertyRulesTemplateVariableArgs(
      name = name.asOutput(isSecret = false),
      `type` = `type`.asOptionOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
