package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GtmAsmapAssignmentArgs private(
  asNumbers: Output[scala.collection.immutable.List[Int]],
  datacenterId: Output[Int],
  nickname: Output[String]
) derives Encoder, ArgsEncoder

object GtmAsmapAssignmentArgs:
  def apply(
    asNumbers: Input[List[Input[Int]]],
    datacenterId: Input[Int],
    nickname: Input[String]
  )(using Context): GtmAsmapAssignmentArgs =
    new GtmAsmapAssignmentArgs(
      asNumbers = asNumbers.asOutput(isSecret = false),
      datacenterId = datacenterId.asOutput(isSecret = false),
      nickname = nickname.asOutput(isSecret = false)
    )
