package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GtmAsmapDefaultDatacenterArgs private(
  datacenterId: Output[Int],
  nickname: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GtmAsmapDefaultDatacenterArgs:
  def apply(
    datacenterId: Input[Int],
    nickname: Input.Optional[String] = None
  )(using Context): GtmAsmapDefaultDatacenterArgs =
    new GtmAsmapDefaultDatacenterArgs(
      datacenterId = datacenterId.asOutput(isSecret = false),
      nickname = nickname.asOptionOutput(isSecret = false)
    )
