package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GtmDatacenterDefaultLoadObjectArgs private(
  loadObject: Output[Option[String]],
  loadObjectPort: Output[Option[Int]],
  loadServers: Output[Option[scala.collection.immutable.List[String]]]
) derives Encoder, ArgsEncoder

object GtmDatacenterDefaultLoadObjectArgs:
  def apply(
    loadObject: Input.Optional[String] = None,
    loadObjectPort: Input.Optional[Int] = None,
    loadServers: Input.Optional[List[Input[String]]] = None
  )(using Context): GtmDatacenterDefaultLoadObjectArgs =
    new GtmDatacenterDefaultLoadObjectArgs(
      loadObject = loadObject.asOptionOutput(isSecret = false),
      loadObjectPort = loadObjectPort.asOptionOutput(isSecret = false),
      loadServers = loadServers.asOptionOutput(isSecret = false)
    )
