package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GtmGeomapAssignmentArgs private(
  countries: Output[Option[scala.collection.immutable.List[String]]],
  datacenterId: Output[Int],
  nickname: Output[String]
) derives Encoder, ArgsEncoder

object GtmGeomapAssignmentArgs:
  def apply(
    countries: Input.Optional[List[Input[String]]] = None,
    datacenterId: Input[Int],
    nickname: Input[String]
  )(using Context): GtmGeomapAssignmentArgs =
    new GtmGeomapAssignmentArgs(
      countries = countries.asOptionOutput(isSecret = false),
      datacenterId = datacenterId.asOutput(isSecret = false),
      nickname = nickname.asOutput(isSecret = false)
    )
