package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GtmPropertyLivenessTestArgs private(
  answersRequired: Output[Option[Boolean]],
  disableNonstandardPortWarning: Output[Option[Boolean]],
  disabled: Output[Option[Boolean]],
  errorPenalty: Output[Option[Double]],
  httpError3xx: Output[Option[Boolean]],
  httpError4xx: Output[Option[Boolean]],
  httpError5xx: Output[Option[Boolean]],
  httpHeaders: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GtmPropertyLivenessTestHttpHeaderArgs]]],
  name: Output[String],
  peerCertificateVerification: Output[Option[Boolean]],
  recursionRequested: Output[Option[Boolean]],
  requestString: Output[Option[String]],
  resourceType: Output[Option[String]],
  responseString: Output[Option[String]],
  sslClientCertificate: Output[Option[String]],
  sslClientPrivateKey: Output[Option[String]],
  testInterval: Output[Int],
  testObject: Output[Option[String]],
  testObjectPassword: Output[Option[String]],
  testObjectPort: Output[Option[Int]],
  testObjectProtocol: Output[String],
  testObjectUsername: Output[Option[String]],
  testTimeout: Output[Double],
  timeoutPenalty: Output[Option[Double]]
) derives Encoder, ArgsEncoder

object GtmPropertyLivenessTestArgs:
  def apply(
    answersRequired: Input.Optional[Boolean] = None,
    disableNonstandardPortWarning: Input.Optional[Boolean] = None,
    disabled: Input.Optional[Boolean] = None,
    errorPenalty: Input.Optional[Double] = None,
    httpError3xx: Input.Optional[Boolean] = None,
    httpError4xx: Input.Optional[Boolean] = None,
    httpError5xx: Input.Optional[Boolean] = None,
    httpHeaders: Input.Optional[List[Input[besom.api.akamai.inputs.GtmPropertyLivenessTestHttpHeaderArgs]]] = None,
    name: Input[String],
    peerCertificateVerification: Input.Optional[Boolean] = None,
    recursionRequested: Input.Optional[Boolean] = None,
    requestString: Input.Optional[String] = None,
    resourceType: Input.Optional[String] = None,
    responseString: Input.Optional[String] = None,
    sslClientCertificate: Input.Optional[String] = None,
    sslClientPrivateKey: Input.Optional[String] = None,
    testInterval: Input[Int],
    testObject: Input.Optional[String] = None,
    testObjectPassword: Input.Optional[String] = None,
    testObjectPort: Input.Optional[Int] = None,
    testObjectProtocol: Input[String],
    testObjectUsername: Input.Optional[String] = None,
    testTimeout: Input[Double],
    timeoutPenalty: Input.Optional[Double] = None
  )(using Context): GtmPropertyLivenessTestArgs =
    new GtmPropertyLivenessTestArgs(
      answersRequired = answersRequired.asOptionOutput(isSecret = false),
      disableNonstandardPortWarning = disableNonstandardPortWarning.asOptionOutput(isSecret = false),
      disabled = disabled.asOptionOutput(isSecret = false),
      errorPenalty = errorPenalty.asOptionOutput(isSecret = false),
      httpError3xx = httpError3xx.asOptionOutput(isSecret = false),
      httpError4xx = httpError4xx.asOptionOutput(isSecret = false),
      httpError5xx = httpError5xx.asOptionOutput(isSecret = false),
      httpHeaders = httpHeaders.asOptionOutput(isSecret = false),
      name = name.asOutput(isSecret = false),
      peerCertificateVerification = peerCertificateVerification.asOptionOutput(isSecret = false),
      recursionRequested = recursionRequested.asOptionOutput(isSecret = false),
      requestString = requestString.asOptionOutput(isSecret = false),
      resourceType = resourceType.asOptionOutput(isSecret = false),
      responseString = responseString.asOptionOutput(isSecret = false),
      sslClientCertificate = sslClientCertificate.asOptionOutput(isSecret = false),
      sslClientPrivateKey = sslClientPrivateKey.asOptionOutput(isSecret = false),
      testInterval = testInterval.asOutput(isSecret = false),
      testObject = testObject.asOptionOutput(isSecret = false),
      testObjectPassword = testObjectPassword.asOptionOutput(isSecret = false),
      testObjectPort = testObjectPort.asOptionOutput(isSecret = false),
      testObjectProtocol = testObjectProtocol.asOutput(isSecret = false),
      testObjectUsername = testObjectUsername.asOptionOutput(isSecret = false),
      testTimeout = testTimeout.asOutput(isSecret = false),
      timeoutPenalty = timeoutPenalty.asOptionOutput(isSecret = false)
    )
