package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GtmPropertyLivenessTestHttpHeaderArgs private(
  name: Output[Option[String]],
  value: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GtmPropertyLivenessTestHttpHeaderArgs:
  def apply(
    name: Input.Optional[String] = None,
    value: Input.Optional[String] = None
  )(using Context): GtmPropertyLivenessTestHttpHeaderArgs =
    new GtmPropertyLivenessTestHttpHeaderArgs(
      name = name.asOptionOutput(isSecret = false),
      value = value.asOptionOutput(isSecret = false)
    )
