package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GtmPropertyTrafficTargetArgs private(
  datacenterId: Output[Option[Int]],
  enabled: Output[Option[Boolean]],
  handoutCname: Output[Option[String]],
  name: Output[Option[String]],
  servers: Output[Option[scala.collection.immutable.List[String]]],
  weight: Output[Option[Double]]
) derives Encoder, ArgsEncoder

object GtmPropertyTrafficTargetArgs:
  def apply(
    datacenterId: Input.Optional[Int] = None,
    enabled: Input.Optional[Boolean] = None,
    handoutCname: Input.Optional[String] = None,
    name: Input.Optional[String] = None,
    servers: Input.Optional[List[Input[String]]] = None,
    weight: Input.Optional[Double] = None
  )(using Context): GtmPropertyTrafficTargetArgs =
    new GtmPropertyTrafficTargetArgs(
      datacenterId = datacenterId.asOptionOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      handoutCname = handoutCname.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      servers = servers.asOptionOutput(isSecret = false),
      weight = weight.asOptionOutput(isSecret = false)
    )
