package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GtmResourceResourceInstanceArgs private(
  datacenterId: Output[Int],
  loadObject: Output[Option[String]],
  loadObjectPort: Output[Option[Int]],
  loadServers: Output[Option[scala.collection.immutable.List[String]]],
  useDefaultLoadObject: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GtmResourceResourceInstanceArgs:
  def apply(
    datacenterId: Input[Int],
    loadObject: Input.Optional[String] = None,
    loadObjectPort: Input.Optional[Int] = None,
    loadServers: Input.Optional[List[Input[String]]] = None,
    useDefaultLoadObject: Input.Optional[Boolean] = None
  )(using Context): GtmResourceResourceInstanceArgs =
    new GtmResourceResourceInstanceArgs(
      datacenterId = datacenterId.asOutput(isSecret = false),
      loadObject = loadObject.asOptionOutput(isSecret = false),
      loadObjectPort = loadObjectPort.asOptionOutput(isSecret = false),
      loadServers = loadServers.asOptionOutput(isSecret = false),
      useDefaultLoadObject = useDefaultLoadObject.asOptionOutput(isSecret = false)
    )
