package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PropertyActivationComplianceRecordArgs private(
  noncomplianceReasonEmergency: Output[Option[besom.api.akamai.inputs.PropertyActivationComplianceRecordNoncomplianceReasonEmergencyArgs]],
  noncomplianceReasonNoProductionTraffic: Output[Option[besom.api.akamai.inputs.PropertyActivationComplianceRecordNoncomplianceReasonNoProductionTrafficArgs]],
  noncomplianceReasonNone: Output[Option[besom.api.akamai.inputs.PropertyActivationComplianceRecordNoncomplianceReasonNoneArgs]],
  noncomplianceReasonOther: Output[Option[besom.api.akamai.inputs.PropertyActivationComplianceRecordNoncomplianceReasonOtherArgs]]
) derives Encoder, ArgsEncoder

object PropertyActivationComplianceRecordArgs:
  def apply(
    noncomplianceReasonEmergency: Input.Optional[besom.api.akamai.inputs.PropertyActivationComplianceRecordNoncomplianceReasonEmergencyArgs] = None,
    noncomplianceReasonNoProductionTraffic: Input.Optional[besom.api.akamai.inputs.PropertyActivationComplianceRecordNoncomplianceReasonNoProductionTrafficArgs] = None,
    noncomplianceReasonNone: Input.Optional[besom.api.akamai.inputs.PropertyActivationComplianceRecordNoncomplianceReasonNoneArgs] = None,
    noncomplianceReasonOther: Input.Optional[besom.api.akamai.inputs.PropertyActivationComplianceRecordNoncomplianceReasonOtherArgs] = None
  )(using Context): PropertyActivationComplianceRecordArgs =
    new PropertyActivationComplianceRecordArgs(
      noncomplianceReasonEmergency = noncomplianceReasonEmergency.asOptionOutput(isSecret = false),
      noncomplianceReasonNoProductionTraffic = noncomplianceReasonNoProductionTraffic.asOptionOutput(isSecret = false),
      noncomplianceReasonNone = noncomplianceReasonNone.asOptionOutput(isSecret = false),
      noncomplianceReasonOther = noncomplianceReasonOther.asOptionOutput(isSecret = false)
    )
