package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PropertyActivationComplianceRecordNoncomplianceReasonNoneArgs private(
  customerEmail: Output[Option[String]],
  peerReviewedBy: Output[Option[String]],
  ticketId: Output[Option[String]],
  unitTested: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object PropertyActivationComplianceRecordNoncomplianceReasonNoneArgs:
  def apply(
    customerEmail: Input.Optional[String] = None,
    peerReviewedBy: Input.Optional[String] = None,
    ticketId: Input.Optional[String] = None,
    unitTested: Input.Optional[Boolean] = None
  )(using Context): PropertyActivationComplianceRecordNoncomplianceReasonNoneArgs =
    new PropertyActivationComplianceRecordNoncomplianceReasonNoneArgs(
      customerEmail = customerEmail.asOptionOutput(isSecret = false),
      peerReviewedBy = peerReviewedBy.asOptionOutput(isSecret = false),
      ticketId = ticketId.asOptionOutput(isSecret = false),
      unitTested = unitTested.asOptionOutput(isSecret = false)
    )
