package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PropertyActivationRuleErrorArgs private(
  behaviorName: Output[Option[String]],
  detail: Output[Option[String]],
  errorLocation: Output[Option[String]],
  instance: Output[Option[String]],
  statusCode: Output[Option[Int]],
  title: Output[Option[String]],
  `type`: Output[Option[String]]
) derives Encoder, ArgsEncoder

object PropertyActivationRuleErrorArgs:
  def apply(
    behaviorName: Input.Optional[String] = None,
    detail: Input.Optional[String] = None,
    errorLocation: Input.Optional[String] = None,
    instance: Input.Optional[String] = None,
    statusCode: Input.Optional[Int] = None,
    title: Input.Optional[String] = None,
    `type`: Input.Optional[String] = None
  )(using Context): PropertyActivationRuleErrorArgs =
    new PropertyActivationRuleErrorArgs(
      behaviorName = behaviorName.asOptionOutput(isSecret = false),
      detail = detail.asOptionOutput(isSecret = false),
      errorLocation = errorLocation.asOptionOutput(isSecret = false),
      instance = instance.asOptionOutput(isSecret = false),
      statusCode = statusCode.asOptionOutput(isSecret = false),
      title = title.asOptionOutput(isSecret = false),
      `type` = `type`.asOptionOutput(isSecret = false)
    )
