package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PropertyHostnameArgs private(
  certProvisioningType: Output[String],
  certStatuses: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.PropertyHostnameCertStatusArgs]]],
  cnameFrom: Output[String],
  cnameTo: Output[String],
  cnameType: Output[Option[String]],
  edgeHostnameId: Output[Option[String]]
) derives Encoder, ArgsEncoder

object PropertyHostnameArgs:
  def apply(
    certProvisioningType: Input[String],
    certStatuses: Input.Optional[List[Input[besom.api.akamai.inputs.PropertyHostnameCertStatusArgs]]] = None,
    cnameFrom: Input[String],
    cnameTo: Input[String],
    cnameType: Input.Optional[String] = None,
    edgeHostnameId: Input.Optional[String] = None
  )(using Context): PropertyHostnameArgs =
    new PropertyHostnameArgs(
      certProvisioningType = certProvisioningType.asOutput(isSecret = false),
      certStatuses = certStatuses.asOptionOutput(isSecret = false),
      cnameFrom = cnameFrom.asOutput(isSecret = false),
      cnameTo = cnameTo.asOutput(isSecret = false),
      cnameType = cnameType.asOptionOutput(isSecret = false),
      edgeHostnameId = edgeHostnameId.asOptionOutput(isSecret = false)
    )
