package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PropertyHostnameCertStatusArgs private(
  hostname: Output[Option[String]],
  productionStatus: Output[Option[String]],
  stagingStatus: Output[Option[String]],
  target: Output[Option[String]]
) derives Encoder, ArgsEncoder

object PropertyHostnameCertStatusArgs:
  def apply(
    hostname: Input.Optional[String] = None,
    productionStatus: Input.Optional[String] = None,
    stagingStatus: Input.Optional[String] = None,
    target: Input.Optional[String] = None
  )(using Context): PropertyHostnameCertStatusArgs =
    new PropertyHostnameCertStatusArgs(
      hostname = hostname.asOptionOutput(isSecret = false),
      productionStatus = productionStatus.asOptionOutput(isSecret = false),
      stagingStatus = stagingStatus.asOptionOutput(isSecret = false),
      target = target.asOptionOutput(isSecret = false)
    )
