package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PropertyIncludeActivationComplianceRecordArgs private(
  noncomplianceReasonEmergency: Output[Option[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonEmergencyArgs]],
  noncomplianceReasonNoProductionTraffic: Output[Option[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNoProductionTrafficArgs]],
  noncomplianceReasonNone: Output[Option[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNoneArgs]],
  noncomplianceReasonOther: Output[Option[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonOtherArgs]]
) derives Encoder, ArgsEncoder

object PropertyIncludeActivationComplianceRecordArgs:
  def apply(
    noncomplianceReasonEmergency: Input.Optional[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonEmergencyArgs] = None,
    noncomplianceReasonNoProductionTraffic: Input.Optional[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNoProductionTrafficArgs] = None,
    noncomplianceReasonNone: Input.Optional[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonNoneArgs] = None,
    noncomplianceReasonOther: Input.Optional[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordNoncomplianceReasonOtherArgs] = None
  )(using Context): PropertyIncludeActivationComplianceRecordArgs =
    new PropertyIncludeActivationComplianceRecordArgs(
      noncomplianceReasonEmergency = noncomplianceReasonEmergency.asOptionOutput(isSecret = false),
      noncomplianceReasonNoProductionTraffic = noncomplianceReasonNoProductionTraffic.asOptionOutput(isSecret = false),
      noncomplianceReasonNone = noncomplianceReasonNone.asOptionOutput(isSecret = false),
      noncomplianceReasonOther = noncomplianceReasonOther.asOptionOutput(isSecret = false)
    )
