package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ProviderConfigArgs private(
  accessToken: Output[String],
  accountKey: Output[Option[String]],
  clientSecret: Output[String],
  clientToken: Output[String],
  host: Output[String],
  maxBody: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object ProviderConfigArgs:
  def apply(
    accessToken: Input[String],
    accountKey: Input.Optional[String] = None,
    clientSecret: Input[String],
    clientToken: Input[String],
    host: Input[String],
    maxBody: Input.Optional[Int] = None
  )(using Context): ProviderConfigArgs =
    new ProviderConfigArgs(
      accessToken = accessToken.asOutput(isSecret = false),
      accountKey = accountKey.asOptionOutput(isSecret = false),
      clientSecret = clientSecret.asOutput(isSecret = false),
      clientToken = clientToken.asOutput(isSecret = false),
      host = host.asOutput(isSecret = false),
      maxBody = maxBody.asOptionOutput(isSecret = false)
    )
