package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ClientlistListItem private(
  description: Option[String],
  expirationDate: Option[String],
  tags: Option[scala.collection.immutable.List[String]],
  value: String
) derives Decoder

object ClientlistListItem:
  given outputOps: {} with
    extension(output: Output[ClientlistListItem])
      def description: Output[Option[String]] = output.map(_.description)
      def expirationDate: Output[Option[String]] = output.map(_.expirationDate)
      def tags: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.tags)
      def value: Output[String] = output.map(_.value)

  given optionOutputOps: {} with
    extension(output: Output[Option[ClientlistListItem]])
      def description: Output[Option[String]] = output.map(_.flatMap(_.description))
      def expirationDate: Output[Option[String]] = output.map(_.flatMap(_.expirationDate))
      def tags: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.tags))
      def value: Output[Option[String]] = output.map(_.map(_.value))


