package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CloudletsApplicationLoadBalancerDataCenter private(
  city: Option[String],
  cloudServerHostHeaderOverride: Option[Boolean],
  cloudService: Option[Boolean],
  continent: String,
  country: String,
  hostname: Option[String],
  latitude: Double,
  livenessHosts: Option[scala.collection.immutable.List[String]],
  longitude: Double,
  originId: String,
  percent: Double,
  stateOrProvince: Option[String]
) derives Decoder

object CloudletsApplicationLoadBalancerDataCenter:
  given outputOps: {} with
    extension(output: Output[CloudletsApplicationLoadBalancerDataCenter])
      def city: Output[Option[String]] = output.map(_.city)
      def cloudServerHostHeaderOverride: Output[Option[Boolean]] = output.map(_.cloudServerHostHeaderOverride)
      def cloudService: Output[Option[Boolean]] = output.map(_.cloudService)
      def continent: Output[String] = output.map(_.continent)
      def country: Output[String] = output.map(_.country)
      def hostname: Output[Option[String]] = output.map(_.hostname)
      def latitude: Output[Double] = output.map(_.latitude)
      def livenessHosts: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.livenessHosts)
      def longitude: Output[Double] = output.map(_.longitude)
      def originId: Output[String] = output.map(_.originId)
      def percent: Output[Double] = output.map(_.percent)
      def stateOrProvince: Output[Option[String]] = output.map(_.stateOrProvince)

  given optionOutputOps: {} with
    extension(output: Output[Option[CloudletsApplicationLoadBalancerDataCenter]])
      def city: Output[Option[String]] = output.map(_.flatMap(_.city))
      def cloudServerHostHeaderOverride: Output[Option[Boolean]] = output.map(_.flatMap(_.cloudServerHostHeaderOverride))
      def cloudService: Output[Option[Boolean]] = output.map(_.flatMap(_.cloudService))
      def continent: Output[Option[String]] = output.map(_.map(_.continent))
      def country: Output[Option[String]] = output.map(_.map(_.country))
      def hostname: Output[Option[String]] = output.map(_.flatMap(_.hostname))
      def latitude: Output[Option[Double]] = output.map(_.map(_.latitude))
      def livenessHosts: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.livenessHosts))
      def longitude: Output[Option[Double]] = output.map(_.map(_.longitude))
      def originId: Output[Option[String]] = output.map(_.map(_.originId))
      def percent: Output[Option[Double]] = output.map(_.map(_.percent))
      def stateOrProvince: Output[Option[String]] = output.map(_.flatMap(_.stateOrProvince))


