package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CloudletsApplicationLoadBalancerLivenessSettings private(
  additionalHeaders: Option[scala.Predef.Map[String, String]],
  hostHeader: Option[String],
  interval: Option[Int],
  path: String,
  peerCertificateVerification: Option[Boolean],
  port: Int,
  protocol: String,
  requestString: Option[String],
  responseString: Option[String],
  status3xxFailure: Option[Boolean],
  status4xxFailure: Option[Boolean],
  status5xxFailure: Option[Boolean],
  timeout: Option[Double]
) derives Decoder

object CloudletsApplicationLoadBalancerLivenessSettings:
  given outputOps: {} with
    extension(output: Output[CloudletsApplicationLoadBalancerLivenessSettings])
      def additionalHeaders: Output[Option[scala.Predef.Map[String, String]]] = output.map(_.additionalHeaders)
      def hostHeader: Output[Option[String]] = output.map(_.hostHeader)
      def interval: Output[Option[Int]] = output.map(_.interval)
      def path: Output[String] = output.map(_.path)
      def peerCertificateVerification: Output[Option[Boolean]] = output.map(_.peerCertificateVerification)
      def port: Output[Int] = output.map(_.port)
      def protocol: Output[String] = output.map(_.protocol)
      def requestString: Output[Option[String]] = output.map(_.requestString)
      def responseString: Output[Option[String]] = output.map(_.responseString)
      def status3xxFailure: Output[Option[Boolean]] = output.map(_.status3xxFailure)
      def status4xxFailure: Output[Option[Boolean]] = output.map(_.status4xxFailure)
      def status5xxFailure: Output[Option[Boolean]] = output.map(_.status5xxFailure)
      def timeout: Output[Option[Double]] = output.map(_.timeout)

  given optionOutputOps: {} with
    extension(output: Output[Option[CloudletsApplicationLoadBalancerLivenessSettings]])
      def additionalHeaders: Output[Option[scala.Predef.Map[String, String]]] = output.map(_.flatMap(_.additionalHeaders))
      def hostHeader: Output[Option[String]] = output.map(_.flatMap(_.hostHeader))
      def interval: Output[Option[Int]] = output.map(_.flatMap(_.interval))
      def path: Output[Option[String]] = output.map(_.map(_.path))
      def peerCertificateVerification: Output[Option[Boolean]] = output.map(_.flatMap(_.peerCertificateVerification))
      def port: Output[Option[Int]] = output.map(_.map(_.port))
      def protocol: Output[Option[String]] = output.map(_.map(_.protocol))
      def requestString: Output[Option[String]] = output.map(_.flatMap(_.requestString))
      def responseString: Output[Option[String]] = output.map(_.flatMap(_.responseString))
      def status3xxFailure: Output[Option[Boolean]] = output.map(_.flatMap(_.status3xxFailure))
      def status4xxFailure: Output[Option[Boolean]] = output.map(_.flatMap(_.status4xxFailure))
      def status5xxFailure: Output[Option[Boolean]] = output.map(_.flatMap(_.status5xxFailure))
      def timeout: Output[Option[Double]] = output.map(_.flatMap(_.timeout))


