package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CloudwrapperConfigurationLocation private(
  capacity: Option[besom.api.akamai.outputs.CloudwrapperConfigurationLocationCapacity],
  comments: String,
  trafficTypeId: Int
) derives Decoder

object CloudwrapperConfigurationLocation:
  given outputOps: {} with
    extension(output: Output[CloudwrapperConfigurationLocation])
      def capacity: Output[Option[besom.api.akamai.outputs.CloudwrapperConfigurationLocationCapacity]] = output.map(_.capacity)
      def comments: Output[String] = output.map(_.comments)
      def trafficTypeId: Output[Int] = output.map(_.trafficTypeId)

  given optionOutputOps: {} with
    extension(output: Output[Option[CloudwrapperConfigurationLocation]])
      def capacity: Output[Option[besom.api.akamai.outputs.CloudwrapperConfigurationLocationCapacity]] = output.map(_.flatMap(_.capacity))
      def comments: Output[Option[String]] = output.map(_.map(_.comments))
      def trafficTypeId: Output[Option[Int]] = output.map(_.map(_.trafficTypeId))


