package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CpsDvEnrollmentDnsChallenge private(
  domain: Option[String],
  fullPath: Option[String],
  responseBody: Option[String]
) derives Decoder

object CpsDvEnrollmentDnsChallenge:
  given outputOps: {} with
    extension(output: Output[CpsDvEnrollmentDnsChallenge])
      def domain: Output[Option[String]] = output.map(_.domain)
      def fullPath: Output[Option[String]] = output.map(_.fullPath)
      def responseBody: Output[Option[String]] = output.map(_.responseBody)

  given optionOutputOps: {} with
    extension(output: Output[Option[CpsDvEnrollmentDnsChallenge]])
      def domain: Output[Option[String]] = output.map(_.flatMap(_.domain))
      def fullPath: Output[Option[String]] = output.map(_.flatMap(_.fullPath))
      def responseBody: Output[Option[String]] = output.map(_.flatMap(_.responseBody))


