package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CpsDvEnrollmentHttpChallenge private(
  domain: Option[String],
  fullPath: Option[String],
  responseBody: Option[String]
) derives Decoder

object CpsDvEnrollmentHttpChallenge:
  given outputOps: {} with
    extension(output: Output[CpsDvEnrollmentHttpChallenge])
      def domain: Output[Option[String]] = output.map(_.domain)
      def fullPath: Output[Option[String]] = output.map(_.fullPath)
      def responseBody: Output[Option[String]] = output.map(_.responseBody)

  given optionOutputOps: {} with
    extension(output: Output[Option[CpsDvEnrollmentHttpChallenge]])
      def domain: Output[Option[String]] = output.map(_.flatMap(_.domain))
      def fullPath: Output[Option[String]] = output.map(_.flatMap(_.fullPath))
      def responseBody: Output[Option[String]] = output.map(_.flatMap(_.responseBody))


