package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CpsDvEnrollmentNetworkConfigurationClientMutualAuthentication private(
  ocspEnabled: Option[Boolean],
  sendCaListToClient: Option[Boolean],
  setId: Option[String]
) derives Decoder

object CpsDvEnrollmentNetworkConfigurationClientMutualAuthentication:
  given outputOps: {} with
    extension(output: Output[CpsDvEnrollmentNetworkConfigurationClientMutualAuthentication])
      def ocspEnabled: Output[Option[Boolean]] = output.map(_.ocspEnabled)
      def sendCaListToClient: Output[Option[Boolean]] = output.map(_.sendCaListToClient)
      def setId: Output[Option[String]] = output.map(_.setId)

  given optionOutputOps: {} with
    extension(output: Output[Option[CpsDvEnrollmentNetworkConfigurationClientMutualAuthentication]])
      def ocspEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.ocspEnabled))
      def sendCaListToClient: Output[Option[Boolean]] = output.map(_.flatMap(_.sendCaListToClient))
      def setId: Output[Option[String]] = output.map(_.flatMap(_.setId))


