package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CpsDvEnrollmentOrganization private(
  addressLineOne: String,
  addressLineTwo: Option[String],
  city: String,
  countryCode: String,
  name: String,
  phone: String,
  postalCode: String,
  region: String
) derives Decoder

object CpsDvEnrollmentOrganization:
  given outputOps: {} with
    extension(output: Output[CpsDvEnrollmentOrganization])
      def addressLineOne: Output[String] = output.map(_.addressLineOne)
      def addressLineTwo: Output[Option[String]] = output.map(_.addressLineTwo)
      def city: Output[String] = output.map(_.city)
      def countryCode: Output[String] = output.map(_.countryCode)
      def name: Output[String] = output.map(_.name)
      def phone: Output[String] = output.map(_.phone)
      def postalCode: Output[String] = output.map(_.postalCode)
      def region: Output[String] = output.map(_.region)

  given optionOutputOps: {} with
    extension(output: Output[Option[CpsDvEnrollmentOrganization]])
      def addressLineOne: Output[Option[String]] = output.map(_.map(_.addressLineOne))
      def addressLineTwo: Output[Option[String]] = output.map(_.flatMap(_.addressLineTwo))
      def city: Output[Option[String]] = output.map(_.map(_.city))
      def countryCode: Output[Option[String]] = output.map(_.map(_.countryCode))
      def name: Output[Option[String]] = output.map(_.map(_.name))
      def phone: Output[Option[String]] = output.map(_.map(_.phone))
      def postalCode: Output[Option[String]] = output.map(_.map(_.postalCode))
      def region: Output[Option[String]] = output.map(_.map(_.region))


