package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CpsDvEnrollmentTechContact private(
  addressLineOne: String,
  addressLineTwo: Option[String],
  city: String,
  countryCode: String,
  email: String,
  firstName: String,
  lastName: String,
  organization: String,
  phone: String,
  postalCode: String,
  region: String,
  title: Option[String]
) derives Decoder

object CpsDvEnrollmentTechContact:
  given outputOps: {} with
    extension(output: Output[CpsDvEnrollmentTechContact])
      def addressLineOne: Output[String] = output.map(_.addressLineOne)
      def addressLineTwo: Output[Option[String]] = output.map(_.addressLineTwo)
      def city: Output[String] = output.map(_.city)
      def countryCode: Output[String] = output.map(_.countryCode)
      def email: Output[String] = output.map(_.email)
      def firstName: Output[String] = output.map(_.firstName)
      def lastName: Output[String] = output.map(_.lastName)
      def organization: Output[String] = output.map(_.organization)
      def phone: Output[String] = output.map(_.phone)
      def postalCode: Output[String] = output.map(_.postalCode)
      def region: Output[String] = output.map(_.region)
      def title: Output[Option[String]] = output.map(_.title)

  given optionOutputOps: {} with
    extension(output: Output[Option[CpsDvEnrollmentTechContact]])
      def addressLineOne: Output[Option[String]] = output.map(_.map(_.addressLineOne))
      def addressLineTwo: Output[Option[String]] = output.map(_.flatMap(_.addressLineTwo))
      def city: Output[Option[String]] = output.map(_.map(_.city))
      def countryCode: Output[Option[String]] = output.map(_.map(_.countryCode))
      def email: Output[Option[String]] = output.map(_.map(_.email))
      def firstName: Output[Option[String]] = output.map(_.map(_.firstName))
      def lastName: Output[Option[String]] = output.map(_.map(_.lastName))
      def organization: Output[Option[String]] = output.map(_.map(_.organization))
      def phone: Output[Option[String]] = output.map(_.map(_.phone))
      def postalCode: Output[Option[String]] = output.map(_.map(_.postalCode))
      def region: Output[Option[String]] = output.map(_.map(_.region))
      def title: Output[Option[String]] = output.map(_.flatMap(_.title))


