package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CpsThirdPartyEnrollmentNetworkConfiguration private(
  clientMutualAuthentication: Option[besom.api.akamai.outputs.CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthentication],
  cloneDnsNames: Option[Boolean],
  disallowedTlsVersions: Option[scala.collection.immutable.List[String]],
  geography: String,
  mustHaveCiphers: Option[String],
  ocspStapling: Option[String],
  preferredCiphers: Option[String],
  quicEnabled: Option[Boolean]
) derives Decoder

object CpsThirdPartyEnrollmentNetworkConfiguration:
  given outputOps: {} with
    extension(output: Output[CpsThirdPartyEnrollmentNetworkConfiguration])
      def clientMutualAuthentication: Output[Option[besom.api.akamai.outputs.CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthentication]] = output.map(_.clientMutualAuthentication)
      def cloneDnsNames: Output[Option[Boolean]] = output.map(_.cloneDnsNames)
      def disallowedTlsVersions: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.disallowedTlsVersions)
      def geography: Output[String] = output.map(_.geography)
      def mustHaveCiphers: Output[Option[String]] = output.map(_.mustHaveCiphers)
      def ocspStapling: Output[Option[String]] = output.map(_.ocspStapling)
      def preferredCiphers: Output[Option[String]] = output.map(_.preferredCiphers)
      def quicEnabled: Output[Option[Boolean]] = output.map(_.quicEnabled)

  given optionOutputOps: {} with
    extension(output: Output[Option[CpsThirdPartyEnrollmentNetworkConfiguration]])
      def clientMutualAuthentication: Output[Option[besom.api.akamai.outputs.CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthentication]] = output.map(_.flatMap(_.clientMutualAuthentication))
      def cloneDnsNames: Output[Option[Boolean]] = output.map(_.flatMap(_.cloneDnsNames))
      def disallowedTlsVersions: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.disallowedTlsVersions))
      def geography: Output[Option[String]] = output.map(_.map(_.geography))
      def mustHaveCiphers: Output[Option[String]] = output.map(_.flatMap(_.mustHaveCiphers))
      def ocspStapling: Output[Option[String]] = output.map(_.flatMap(_.ocspStapling))
      def preferredCiphers: Output[Option[String]] = output.map(_.flatMap(_.preferredCiphers))
      def quicEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.quicEnabled))


