package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthentication private(
  ocspEnabled: Option[Boolean],
  sendCaListToClient: Option[Boolean],
  setId: Option[String]
) derives Decoder

object CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthentication:
  given outputOps: {} with
    extension(output: Output[CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthentication])
      def ocspEnabled: Output[Option[Boolean]] = output.map(_.ocspEnabled)
      def sendCaListToClient: Output[Option[Boolean]] = output.map(_.sendCaListToClient)
      def setId: Output[Option[String]] = output.map(_.setId)

  given optionOutputOps: {} with
    extension(output: Output[Option[CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthentication]])
      def ocspEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.ocspEnabled))
      def sendCaListToClient: Output[Option[Boolean]] = output.map(_.flatMap(_.sendCaListToClient))
      def setId: Output[Option[String]] = output.map(_.flatMap(_.setId))


