package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DatastreamAzureConnector private(
  accessKey: String,
  accountName: String,
  compressLogs: Option[Boolean],
  containerName: String,
  displayName: String,
  path: String
) derives Decoder

object DatastreamAzureConnector:
  given outputOps: {} with
    extension(output: Output[DatastreamAzureConnector])
      def accessKey: Output[String] = output.map(_.accessKey)
      def accountName: Output[String] = output.map(_.accountName)
      def compressLogs: Output[Option[Boolean]] = output.map(_.compressLogs)
      def containerName: Output[String] = output.map(_.containerName)
      def displayName: Output[String] = output.map(_.displayName)
      def path: Output[String] = output.map(_.path)

  given optionOutputOps: {} with
    extension(output: Output[Option[DatastreamAzureConnector]])
      def accessKey: Output[Option[String]] = output.map(_.map(_.accessKey))
      def accountName: Output[Option[String]] = output.map(_.map(_.accountName))
      def compressLogs: Output[Option[Boolean]] = output.map(_.flatMap(_.compressLogs))
      def containerName: Output[Option[String]] = output.map(_.map(_.containerName))
      def displayName: Output[Option[String]] = output.map(_.map(_.displayName))
      def path: Output[Option[String]] = output.map(_.map(_.path))


