package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DatastreamDatadogConnector private(
  authToken: String,
  compressLogs: Option[Boolean],
  displayName: String,
  endpoint: String,
  service: Option[String],
  source: Option[String],
  tags: Option[String]
) derives Decoder

object DatastreamDatadogConnector:
  given outputOps: {} with
    extension(output: Output[DatastreamDatadogConnector])
      def authToken: Output[String] = output.map(_.authToken)
      def compressLogs: Output[Option[Boolean]] = output.map(_.compressLogs)
      def displayName: Output[String] = output.map(_.displayName)
      def endpoint: Output[String] = output.map(_.endpoint)
      def service: Output[Option[String]] = output.map(_.service)
      def source: Output[Option[String]] = output.map(_.source)
      def tags: Output[Option[String]] = output.map(_.tags)

  given optionOutputOps: {} with
    extension(output: Output[Option[DatastreamDatadogConnector]])
      def authToken: Output[Option[String]] = output.map(_.map(_.authToken))
      def compressLogs: Output[Option[Boolean]] = output.map(_.flatMap(_.compressLogs))
      def displayName: Output[Option[String]] = output.map(_.map(_.displayName))
      def endpoint: Output[Option[String]] = output.map(_.map(_.endpoint))
      def service: Output[Option[String]] = output.map(_.flatMap(_.service))
      def source: Output[Option[String]] = output.map(_.flatMap(_.source))
      def tags: Output[Option[String]] = output.map(_.flatMap(_.tags))


