package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DatastreamDeliveryConfiguration private(
  fieldDelimiter: Option[String],
  format: String,
  frequency: besom.api.akamai.outputs.DatastreamDeliveryConfigurationFrequency,
  uploadFilePrefix: Option[String],
  uploadFileSuffix: Option[String]
) derives Decoder

object DatastreamDeliveryConfiguration:
  given outputOps: {} with
    extension(output: Output[DatastreamDeliveryConfiguration])
      def fieldDelimiter: Output[Option[String]] = output.map(_.fieldDelimiter)
      def format: Output[String] = output.map(_.format)
      def frequency: Output[besom.api.akamai.outputs.DatastreamDeliveryConfigurationFrequency] = output.map(_.frequency)
      def uploadFilePrefix: Output[Option[String]] = output.map(_.uploadFilePrefix)
      def uploadFileSuffix: Output[Option[String]] = output.map(_.uploadFileSuffix)

  given optionOutputOps: {} with
    extension(output: Output[Option[DatastreamDeliveryConfiguration]])
      def fieldDelimiter: Output[Option[String]] = output.map(_.flatMap(_.fieldDelimiter))
      def format: Output[Option[String]] = output.map(_.map(_.format))
      def frequency: Output[Option[besom.api.akamai.outputs.DatastreamDeliveryConfigurationFrequency]] = output.map(_.map(_.frequency))
      def uploadFilePrefix: Output[Option[String]] = output.map(_.flatMap(_.uploadFilePrefix))
      def uploadFileSuffix: Output[Option[String]] = output.map(_.flatMap(_.uploadFileSuffix))


