package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DatastreamElasticsearchConnector private(
  caCert: Option[String],
  clientCert: Option[String],
  clientKey: Option[String],
  contentType: Option[String],
  customHeaderName: Option[String],
  customHeaderValue: Option[String],
  displayName: String,
  endpoint: String,
  indexName: String,
  mTls: Option[Boolean],
  password: String,
  tlsHostname: Option[String],
  userName: String
) derives Decoder

object DatastreamElasticsearchConnector:
  given outputOps: {} with
    extension(output: Output[DatastreamElasticsearchConnector])
      def caCert: Output[Option[String]] = output.map(_.caCert)
      def clientCert: Output[Option[String]] = output.map(_.clientCert)
      def clientKey: Output[Option[String]] = output.map(_.clientKey)
      def contentType: Output[Option[String]] = output.map(_.contentType)
      def customHeaderName: Output[Option[String]] = output.map(_.customHeaderName)
      def customHeaderValue: Output[Option[String]] = output.map(_.customHeaderValue)
      def displayName: Output[String] = output.map(_.displayName)
      def endpoint: Output[String] = output.map(_.endpoint)
      def indexName: Output[String] = output.map(_.indexName)
      def mTls: Output[Option[Boolean]] = output.map(_.mTls)
      def password: Output[String] = output.map(_.password)
      def tlsHostname: Output[Option[String]] = output.map(_.tlsHostname)
      def userName: Output[String] = output.map(_.userName)

  given optionOutputOps: {} with
    extension(output: Output[Option[DatastreamElasticsearchConnector]])
      def caCert: Output[Option[String]] = output.map(_.flatMap(_.caCert))
      def clientCert: Output[Option[String]] = output.map(_.flatMap(_.clientCert))
      def clientKey: Output[Option[String]] = output.map(_.flatMap(_.clientKey))
      def contentType: Output[Option[String]] = output.map(_.flatMap(_.contentType))
      def customHeaderName: Output[Option[String]] = output.map(_.flatMap(_.customHeaderName))
      def customHeaderValue: Output[Option[String]] = output.map(_.flatMap(_.customHeaderValue))
      def displayName: Output[Option[String]] = output.map(_.map(_.displayName))
      def endpoint: Output[Option[String]] = output.map(_.map(_.endpoint))
      def indexName: Output[Option[String]] = output.map(_.map(_.indexName))
      def mTls: Output[Option[Boolean]] = output.map(_.flatMap(_.mTls))
      def password: Output[Option[String]] = output.map(_.map(_.password))
      def tlsHostname: Output[Option[String]] = output.map(_.flatMap(_.tlsHostname))
      def userName: Output[Option[String]] = output.map(_.map(_.userName))


