package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DatastreamGcsConnector private(
  bucket: String,
  compressLogs: Option[Boolean],
  displayName: String,
  path: Option[String],
  privateKey: String,
  projectId: String,
  serviceAccountName: String
) derives Decoder

object DatastreamGcsConnector:
  given outputOps: {} with
    extension(output: Output[DatastreamGcsConnector])
      def bucket: Output[String] = output.map(_.bucket)
      def compressLogs: Output[Option[Boolean]] = output.map(_.compressLogs)
      def displayName: Output[String] = output.map(_.displayName)
      def path: Output[Option[String]] = output.map(_.path)
      def privateKey: Output[String] = output.map(_.privateKey)
      def projectId: Output[String] = output.map(_.projectId)
      def serviceAccountName: Output[String] = output.map(_.serviceAccountName)

  given optionOutputOps: {} with
    extension(output: Output[Option[DatastreamGcsConnector]])
      def bucket: Output[Option[String]] = output.map(_.map(_.bucket))
      def compressLogs: Output[Option[Boolean]] = output.map(_.flatMap(_.compressLogs))
      def displayName: Output[Option[String]] = output.map(_.map(_.displayName))
      def path: Output[Option[String]] = output.map(_.flatMap(_.path))
      def privateKey: Output[Option[String]] = output.map(_.map(_.privateKey))
      def projectId: Output[Option[String]] = output.map(_.map(_.projectId))
      def serviceAccountName: Output[Option[String]] = output.map(_.map(_.serviceAccountName))


