package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DatastreamLogglyConnector private(
  authToken: String,
  contentType: Option[String],
  customHeaderName: Option[String],
  customHeaderValue: Option[String],
  displayName: String,
  endpoint: String,
  tags: Option[String]
) derives Decoder

object DatastreamLogglyConnector:
  given outputOps: {} with
    extension(output: Output[DatastreamLogglyConnector])
      def authToken: Output[String] = output.map(_.authToken)
      def contentType: Output[Option[String]] = output.map(_.contentType)
      def customHeaderName: Output[Option[String]] = output.map(_.customHeaderName)
      def customHeaderValue: Output[Option[String]] = output.map(_.customHeaderValue)
      def displayName: Output[String] = output.map(_.displayName)
      def endpoint: Output[String] = output.map(_.endpoint)
      def tags: Output[Option[String]] = output.map(_.tags)

  given optionOutputOps: {} with
    extension(output: Output[Option[DatastreamLogglyConnector]])
      def authToken: Output[Option[String]] = output.map(_.map(_.authToken))
      def contentType: Output[Option[String]] = output.map(_.flatMap(_.contentType))
      def customHeaderName: Output[Option[String]] = output.map(_.flatMap(_.customHeaderName))
      def customHeaderValue: Output[Option[String]] = output.map(_.flatMap(_.customHeaderValue))
      def displayName: Output[Option[String]] = output.map(_.map(_.displayName))
      def endpoint: Output[Option[String]] = output.map(_.map(_.endpoint))
      def tags: Output[Option[String]] = output.map(_.flatMap(_.tags))


