package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DatastreamNewRelicConnector private(
  authToken: String,
  contentType: Option[String],
  customHeaderName: Option[String],
  customHeaderValue: Option[String],
  displayName: String,
  endpoint: String
) derives Decoder

object DatastreamNewRelicConnector:
  given outputOps: {} with
    extension(output: Output[DatastreamNewRelicConnector])
      def authToken: Output[String] = output.map(_.authToken)
      def contentType: Output[Option[String]] = output.map(_.contentType)
      def customHeaderName: Output[Option[String]] = output.map(_.customHeaderName)
      def customHeaderValue: Output[Option[String]] = output.map(_.customHeaderValue)
      def displayName: Output[String] = output.map(_.displayName)
      def endpoint: Output[String] = output.map(_.endpoint)

  given optionOutputOps: {} with
    extension(output: Output[Option[DatastreamNewRelicConnector]])
      def authToken: Output[Option[String]] = output.map(_.map(_.authToken))
      def contentType: Output[Option[String]] = output.map(_.flatMap(_.contentType))
      def customHeaderName: Output[Option[String]] = output.map(_.flatMap(_.customHeaderName))
      def customHeaderValue: Output[Option[String]] = output.map(_.flatMap(_.customHeaderValue))
      def displayName: Output[Option[String]] = output.map(_.map(_.displayName))
      def endpoint: Output[Option[String]] = output.map(_.map(_.endpoint))


