package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DatastreamOracleConnector private(
  accessKey: String,
  bucket: String,
  compressLogs: Option[Boolean],
  displayName: String,
  namespace: String,
  path: String,
  region: String,
  secretAccessKey: String
) derives Decoder

object DatastreamOracleConnector:
  given outputOps: {} with
    extension(output: Output[DatastreamOracleConnector])
      def accessKey: Output[String] = output.map(_.accessKey)
      def bucket: Output[String] = output.map(_.bucket)
      def compressLogs: Output[Option[Boolean]] = output.map(_.compressLogs)
      def displayName: Output[String] = output.map(_.displayName)
      def namespace: Output[String] = output.map(_.namespace)
      def path: Output[String] = output.map(_.path)
      def region: Output[String] = output.map(_.region)
      def secretAccessKey: Output[String] = output.map(_.secretAccessKey)

  given optionOutputOps: {} with
    extension(output: Output[Option[DatastreamOracleConnector]])
      def accessKey: Output[Option[String]] = output.map(_.map(_.accessKey))
      def bucket: Output[Option[String]] = output.map(_.map(_.bucket))
      def compressLogs: Output[Option[Boolean]] = output.map(_.flatMap(_.compressLogs))
      def displayName: Output[Option[String]] = output.map(_.map(_.displayName))
      def namespace: Output[Option[String]] = output.map(_.map(_.namespace))
      def path: Output[Option[String]] = output.map(_.map(_.path))
      def region: Output[Option[String]] = output.map(_.map(_.region))
      def secretAccessKey: Output[Option[String]] = output.map(_.map(_.secretAccessKey))


