package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DatastreamSplunkConnector private(
  caCert: Option[String],
  clientCert: Option[String],
  clientKey: Option[String],
  compressLogs: Option[Boolean],
  customHeaderName: Option[String],
  customHeaderValue: Option[String],
  displayName: String,
  endpoint: String,
  eventCollectorToken: String,
  mTls: Option[Boolean],
  tlsHostname: Option[String]
) derives Decoder

object DatastreamSplunkConnector:
  given outputOps: {} with
    extension(output: Output[DatastreamSplunkConnector])
      def caCert: Output[Option[String]] = output.map(_.caCert)
      def clientCert: Output[Option[String]] = output.map(_.clientCert)
      def clientKey: Output[Option[String]] = output.map(_.clientKey)
      def compressLogs: Output[Option[Boolean]] = output.map(_.compressLogs)
      def customHeaderName: Output[Option[String]] = output.map(_.customHeaderName)
      def customHeaderValue: Output[Option[String]] = output.map(_.customHeaderValue)
      def displayName: Output[String] = output.map(_.displayName)
      def endpoint: Output[String] = output.map(_.endpoint)
      def eventCollectorToken: Output[String] = output.map(_.eventCollectorToken)
      def mTls: Output[Option[Boolean]] = output.map(_.mTls)
      def tlsHostname: Output[Option[String]] = output.map(_.tlsHostname)

  given optionOutputOps: {} with
    extension(output: Output[Option[DatastreamSplunkConnector]])
      def caCert: Output[Option[String]] = output.map(_.flatMap(_.caCert))
      def clientCert: Output[Option[String]] = output.map(_.flatMap(_.clientCert))
      def clientKey: Output[Option[String]] = output.map(_.flatMap(_.clientKey))
      def compressLogs: Output[Option[Boolean]] = output.map(_.flatMap(_.compressLogs))
      def customHeaderName: Output[Option[String]] = output.map(_.flatMap(_.customHeaderName))
      def customHeaderValue: Output[Option[String]] = output.map(_.flatMap(_.customHeaderValue))
      def displayName: Output[Option[String]] = output.map(_.map(_.displayName))
      def endpoint: Output[Option[String]] = output.map(_.map(_.endpoint))
      def eventCollectorToken: Output[Option[String]] = output.map(_.map(_.eventCollectorToken))
      def mTls: Output[Option[Boolean]] = output.map(_.flatMap(_.mTls))
      def tlsHostname: Output[Option[String]] = output.map(_.flatMap(_.tlsHostname))


