package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class DnsZoneTsigKey private(
  algorithm: String,
  name: String,
  secret: String
) derives Decoder

object DnsZoneTsigKey:
  given outputOps: {} with
    extension(output: Output[DnsZoneTsigKey])
      def algorithm: Output[String] = output.map(_.algorithm)
      def name: Output[String] = output.map(_.name)
      def secret: Output[String] = output.map(_.secret)

  given optionOutputOps: {} with
    extension(output: Output[Option[DnsZoneTsigKey]])
      def algorithm: Output[Option[String]] = output.map(_.map(_.algorithm))
      def name: Output[Option[String]] = output.map(_.map(_.name))
      def secret: Output[Option[String]] = output.map(_.map(_.secret))


