package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class EdgeKvInitialData private(
  group: Option[String],
  key: String,
  value: String
) derives Decoder

object EdgeKvInitialData:
  given outputOps: {} with
    extension(output: Output[EdgeKvInitialData])
      def group: Output[Option[String]] = output.map(_.group)
      def key: Output[String] = output.map(_.key)
      def value: Output[String] = output.map(_.value)

  given optionOutputOps: {} with
    extension(output: Output[Option[EdgeKvInitialData]])
      def group: Output[Option[String]] = output.map(_.flatMap(_.group))
      def key: Output[Option[String]] = output.map(_.map(_.key))
      def value: Output[Option[String]] = output.map(_.map(_.value))


