package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCPSEnrollmentDnsChallenge private(
  domain: String,
  fullPath: String,
  responseBody: String
) derives Decoder

object GetCPSEnrollmentDnsChallenge:
  given outputOps: {} with
    extension(output: Output[GetCPSEnrollmentDnsChallenge])
      def domain: Output[String] = output.map(_.domain)
      def fullPath: Output[String] = output.map(_.fullPath)
      def responseBody: Output[String] = output.map(_.responseBody)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCPSEnrollmentDnsChallenge]])
      def domain: Output[Option[String]] = output.map(_.map(_.domain))
      def fullPath: Output[Option[String]] = output.map(_.map(_.fullPath))
      def responseBody: Output[Option[String]] = output.map(_.map(_.responseBody))


