package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCPSEnrollmentNetworkConfiguration private(
  clientMutualAuthentications: scala.collection.immutable.List[besom.api.akamai.outputs.GetCPSEnrollmentNetworkConfigurationClientMutualAuthentication],
  cloneDnsNames: Boolean,
  disallowedTlsVersions: scala.collection.immutable.List[String],
  geography: String,
  mustHaveCiphers: String,
  ocspStapling: String,
  preferredCiphers: String,
  quicEnabled: Boolean
) derives Decoder

object GetCPSEnrollmentNetworkConfiguration:
  given outputOps: {} with
    extension(output: Output[GetCPSEnrollmentNetworkConfiguration])
      def clientMutualAuthentications: Output[scala.collection.immutable.List[besom.api.akamai.outputs.GetCPSEnrollmentNetworkConfigurationClientMutualAuthentication]] = output.map(_.clientMutualAuthentications)
      def cloneDnsNames: Output[Boolean] = output.map(_.cloneDnsNames)
      def disallowedTlsVersions: Output[scala.collection.immutable.List[String]] = output.map(_.disallowedTlsVersions)
      def geography: Output[String] = output.map(_.geography)
      def mustHaveCiphers: Output[String] = output.map(_.mustHaveCiphers)
      def ocspStapling: Output[String] = output.map(_.ocspStapling)
      def preferredCiphers: Output[String] = output.map(_.preferredCiphers)
      def quicEnabled: Output[Boolean] = output.map(_.quicEnabled)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCPSEnrollmentNetworkConfiguration]])
      def clientMutualAuthentications: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCPSEnrollmentNetworkConfigurationClientMutualAuthentication]]] = output.map(_.map(_.clientMutualAuthentications))
      def cloneDnsNames: Output[Option[Boolean]] = output.map(_.map(_.cloneDnsNames))
      def disallowedTlsVersions: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.map(_.disallowedTlsVersions))
      def geography: Output[Option[String]] = output.map(_.map(_.geography))
      def mustHaveCiphers: Output[Option[String]] = output.map(_.map(_.mustHaveCiphers))
      def ocspStapling: Output[Option[String]] = output.map(_.map(_.ocspStapling))
      def preferredCiphers: Output[Option[String]] = output.map(_.map(_.preferredCiphers))
      def quicEnabled: Output[Option[Boolean]] = output.map(_.map(_.quicEnabled))


