package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCPSEnrollmentNetworkConfigurationClientMutualAuthentication private(
  ocspEnabled: Boolean,
  sendCaListToClient: Boolean,
  setId: String
) derives Decoder

object GetCPSEnrollmentNetworkConfigurationClientMutualAuthentication:
  given outputOps: {} with
    extension(output: Output[GetCPSEnrollmentNetworkConfigurationClientMutualAuthentication])
      def ocspEnabled: Output[Boolean] = output.map(_.ocspEnabled)
      def sendCaListToClient: Output[Boolean] = output.map(_.sendCaListToClient)
      def setId: Output[String] = output.map(_.setId)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCPSEnrollmentNetworkConfigurationClientMutualAuthentication]])
      def ocspEnabled: Output[Option[Boolean]] = output.map(_.map(_.ocspEnabled))
      def sendCaListToClient: Output[Option[Boolean]] = output.map(_.map(_.sendCaListToClient))
      def setId: Output[Option[String]] = output.map(_.map(_.setId))


